/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.blabber.impl.common.model;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.blabber.api.illustration.DialogueIllustration;
import org.ladysnake.blabber.api.illustration.DialogueIllustrationType;
import org.ladysnake.blabber.api.layout.DialogueLayout;
import org.ladysnake.blabber.api.layout.DialogueLayoutType;
import org.ladysnake.blabber.impl.common.model.DialogueState;

public record DialogueTemplate(String start, boolean unskippable, Map<String, DialogueState> states, Map<String, DialogueIllustration> illustrations, DialogueLayout<?> layout) {
    public static final Codec<DialogueTemplate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("start_at").forGetter(DialogueTemplate::start), (App)Codec.BOOL.optionalFieldOf("unskippable", (Object)false).forGetter(DialogueTemplate::unskippable), (App)Codec.unboundedMap((Codec)Codec.STRING, DialogueState.CODEC).fieldOf("states").forGetter(DialogueTemplate::states), (App)Codec.unboundedMap((Codec)Codec.STRING, DialogueIllustrationType.CODEC).optionalFieldOf("illustrations", Collections.emptyMap()).forGetter(DialogueTemplate::illustrations), (App)DialogueLayoutType.CODEC.optionalFieldOf("layout", DialogueLayout.DEFAULT).forGetter(DialogueTemplate::layout)).apply((Applicative)instance, DialogueTemplate::new));
    public static final class_9139<class_9129, DialogueTemplate> PACKET_CODEC = class_9139.method_56906((class_9139)class_9135.field_48554, DialogueTemplate::start, (class_9139)class_9135.field_48547, DialogueTemplate::unskippable, (class_9139)class_9135.method_56377(HashMap::new, (class_9139)class_9135.field_48554, DialogueState.PACKET_CODEC), DialogueTemplate::states, (class_9139)class_9135.method_56377(HashMap::new, (class_9139)class_9135.field_48554, DialogueIllustrationType.PACKET_CODEC), DialogueTemplate::illustrations, DialogueLayoutType.PACKET_CODEC, DialogueTemplate::layout, DialogueTemplate::new);

    public DialogueTemplate parseText(@Nullable class_2168 source, @Nullable class_1297 sender) throws CommandSyntaxException {
        HashMap<String, DialogueState> parsedStates = new HashMap<String, DialogueState>(this.states().size());
        for (Map.Entry<String, DialogueState> state : this.states().entrySet()) {
            parsedStates.put(state.getKey(), state.getValue().parseText(source, sender));
        }
        HashMap<String, DialogueIllustration> parsedIllustrations = new HashMap<String, DialogueIllustration>(this.illustrations().size());
        for (Map.Entry<String, DialogueIllustration> illustration : this.illustrations().entrySet()) {
            parsedIllustrations.put(illustration.getKey(), illustration.getValue().parseText(source, sender));
        }
        return new DialogueTemplate(this.start(), this.unskippable(), parsedStates, parsedIllustrations, this.layout());
    }

    @Override
    public String toString() {
        return "DialogueTemplate[start=%s, states=%s, illustrations=%s%s]".formatted(this.start, this.states, this.illustrations, this.unskippable ? " (unskippable)" : "");
    }
}

